/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import java.awt.Taskbar;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2874;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3497;
import net.minecraft.class_3611;
import net.minecraft.class_3785;
import net.minecraft.class_3827;
import net.minecraft.class_3828;
import net.minecraft.class_4996;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5497;
import net.minecraft.class_5712;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_6910;
import net.minecraft.class_7059;
import net.minecraft.class_7142;
import net.minecraft.class_7145;
import net.minecraft.class_7243;
import net.minecraft.class_7475;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeData;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.worlds.together.surfaceRules.AssignedSurfaceRule;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleRegistry;

public class DumpDatapack {
    private static final Map<class_2960, Dumper> DUMPERS = new HashMap<class_2960, Dumper>();

    static int dumpDatapack(CommandContext<class_2168> ctx) {
        File base = new File(System.getProperty("user.dir"), "bclib_datapack_dump");
        DumpDatapack.dumpDatapack(base, ((class_2168)ctx.getSource()).method_9225().method_30349(), ctx);
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Succesfully written to:\n    ").method_10852((class_2561)class_2561.method_43470((String)base.toString()).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)))), false);
        return 1;
    }

    public static void dumpDatapack(File base, class_5455 registryAccess, CommandContext<class_2168> ctx) {
        class_6903 registryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)registryAccess);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder = gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        registryAccess.method_40311().forEach(r -> DumpDatapack.dump(base, r, (class_6903<JsonElement>)registryOps, gson));
        BCLib.LOGGER.info("- Serializing Dimensions ");
        for (class_3218 serverLevel : ((class_2168)ctx.getSource()).method_9225().method_8503().method_3738()) {
            File f1 = new File(base, serverLevel.method_27983().method_29177().method_12836());
            f1 = new File(f1, "dimension");
            f1 = new File(f1, serverLevel.method_27983().method_29177().method_12832() + ".json");
            f1.getParentFile().mkdirs();
            try {
                class_5363 stem = new class_5363(serverLevel.method_40134(), serverLevel.method_14178().method_12129());
                Codec codec = class_5363.field_25411;
                JsonObject o = codec.encodeStart((DynamicOps)registryOps, (Object)stem).result().orElse(new JsonObject());
                String content = gson.toJson((Object)o);
                try {
                    Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    BCLib.LOGGER.error("        ->> Unable to WRITE: " + e.getMessage());
                }
            }
            catch (Exception e) {
                BCLib.LOGGER.error("      ->> Unable to encode: " + e.getMessage());
            }
        }
    }

    private static <T> void dump(File base, class_5455.class_6892<T> registry, class_6903<JsonElement> registryOps, Gson gson) {
        BCLib.LOGGER.info("- Serializing: " + registry.comp_350().toString());
        DUMPERS.clear();
        DUMPERS.put(class_2378.field_25114.method_29177(), new Dumper(v -> class_1959.field_25819));
        DUMPERS.put(class_2378.field_25914.method_29177(), new Dumper(v -> class_2975.field_25833));
        DUMPERS.put(class_2378.field_37998.method_29177(), new Dumper(v -> class_7145.field_37725));
        DUMPERS.put(class_2378.field_26374.method_29177(), new Dumper(v -> class_5284.field_24780));
        DUMPERS.put(class_2378.field_25915.method_29177(), new Dumper(v -> class_3195.field_37744));
        DUMPERS.put(class_2378.field_25095.method_29177(), new Dumper(v -> class_2874.field_24757));
        DUMPERS.put(BCLBiomeRegistry.BCL_BIOMES_REGISTRY.method_29177(), new Dumper(v -> v.codec().comp_640()));
        DUMPERS.put(SurfaceRuleRegistry.SURFACE_RULES_REGISTRY.method_29177(), new Dumper(v -> AssignedSurfaceRule.CODEC));
        DUMPERS.put(class_2378.field_25102.method_29177(), new Dumper(v -> class_3414.field_24628));
        DUMPERS.put(class_2378.field_25913.method_29177(), new Dumper(v -> class_2922.field_25832));
        DUMPERS.put(class_2378.field_25916.method_29177(), new Dumper(v -> class_3828.field_25876));
        DUMPERS.put(class_2378.field_37999.method_29177(), new Dumper(v -> class_7142.field_37711));
        DUMPERS.put(class_2378.field_37228.method_29177(), new Dumper(v -> class_6910.field_37057));
        DUMPERS.put(class_2378.field_35758.method_29177(), new Dumper(v -> class_6796.field_35729));
        DUMPERS.put(class_2378.field_35433.method_29177(), new Dumper(v -> class_5216.class_5487.field_35424));
        DUMPERS.put(class_2378.field_35433.method_29177(), new Dumper(v -> class_5216.class_5487.field_35424));
        DUMPERS.put(class_2378.field_25917.method_29177(), new Dumper(v -> class_3785.field_25853));
        DUMPERS.put(class_2378.field_37227.method_29177(), new Dumper(v -> class_7059.field_37195));
        Dumper d = DUMPERS.getOrDefault(registry.comp_350().method_29177(), new Dumper(v -> registry.comp_351().method_39673()));
        if (d != null) {
            DumpDatapack.dump(base, registry, registryOps, gson, d.codecFunction, d.contentTransform);
        } else {
            BCLib.LOGGER.warning("    No Codec Found", new Object[0]);
        }
    }

    private static <T, S> void dump(File base, class_5455.class_6892<T> registry, class_6903<JsonElement> registryOps, Gson gson, Function<Object, Codec<?>> codecFunction, Function<class_6880<T>, Object> contentTransform) {
        BCLib.LOGGER.info("   - Serializing Tags");
        DumpDatapack.dumpTags(base, registry, registryOps, gson);
        BCLib.LOGGER.info("   - Serializing Content");
        int[] count = new int[]{0, 0};
        registry.comp_351().method_29722().stream().map(e -> (class_5321)e.getKey()).map(key -> (class_6880)registry.comp_351().method_40264(key).get()).forEach(holder -> {
            File f1 = new File(base, ((class_5321)holder.method_40230().get()).method_29177().method_12836());
            f1 = new File(f1, registry.comp_350().method_29177().method_12832());
            f1.mkdirs();
            f1 = new File(f1, ((class_5321)holder.method_40230().get()).method_29177().method_12832() + ".json");
            f1.getParentFile().mkdirs();
            Object obj = contentTransform.apply((class_6880)holder);
            try {
                Codec codec = (Codec)codecFunction.apply(obj);
                JsonObject o = codec.encodeStart((DynamicOps)registryOps, obj).result().orElse(new JsonObject());
                String content = gson.toJson((Object)o);
                try {
                    Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                    count[0] = count[0] + 1;
                }
                catch (IOException e) {
                    count[1] = count[1] + 1;
                    BCLib.LOGGER.error("        ->> Unable to WRITE: " + e.getMessage());
                }
            }
            catch (Exception e) {
                count[1] = count[1] + 1;
                BCLib.LOGGER.error("      ->> Unable to encode: " + e.getMessage());
            }
        });
        BCLib.LOGGER.info("     -> Wrote " + count[0] + " files (" + count[1] + " errors)");
    }

    private static <T> void dumpDatapackOld(File base, class_5455.class_6892<T> registry, class_6903<JsonElement> registryOps, Gson gson) {
        BCLib.LOGGER.info(registry.comp_350().toString());
        DumpDatapack.dumpTags(base, registry, registryOps, gson);
        registry.comp_351().method_29722().stream().map(e -> (class_5321)e.getKey()).map(key -> (class_6880)registry.comp_351().method_40264(key).get()).forEach(holder -> {
            File f1 = new File(base, ((class_5321)holder.method_40230().get()).method_29177().method_12836());
            f1 = new File(f1, registry.comp_350().method_29177().method_12832());
            f1.mkdirs();
            f1 = new File(f1, ((class_5321)holder.method_40230().get()).method_29177().method_12832() + ".json");
            f1.getParentFile().mkdirs();
            Codec[] codec = new Codec[]{null};
            Object obj = holder;
            while (obj instanceof class_6880) {
                obj = obj.comp_349();
            }
            if (obj instanceof class_1966 || obj instanceof Taskbar.Feature) {
                System.out.print("");
            }
            System.out.println(obj.getClass());
            if (obj instanceof class_3195) {
                AccessibleObject[] s = (Method[])obj;
                codec[0] = s.method_41618().codec();
            } else if (obj instanceof BCLBiome) {
                BCLBiome s = (BCLBiome)obj;
                codec[0] = BiomeData.CODEC;
            } else if (obj instanceof class_5497) {
                class_5497 s = (class_5497)obj;
                codec[0] = class_3828.field_26663;
            } else {
                if (obj instanceof class_5712) {
                    return;
                }
                if (obj instanceof class_3611) {
                    return;
                }
                if (obj instanceof class_1291) {
                    return;
                }
                if (obj instanceof BaseStairsBlock) {
                    return;
                }
                if (obj instanceof class_3827) {
                    codec[0] = registry.comp_351().method_39673();
                } else if (obj instanceof class_4996) {
                    codec[0] = registry.comp_351().method_39673();
                } else if (obj instanceof class_5285) {
                    codec[0] = registry.comp_351().method_39673();
                } else if (obj instanceof class_5363) {
                    codec[0] = registry.comp_351().method_39673();
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getMethods()) {
                    if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                    ((Method)accessibleObject).setAccessible(true);
                    if (((Method)accessibleObject).getParameterTypes().length != 0) continue;
                    if (Codec.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) {
                        try {
                            codec[0] = (Codec)((Method)accessibleObject).invoke(obj, new Object[0]);
                            BCLib.LOGGER.debug("      Got Codec from " + (Method)accessibleObject);
                            break;
                        }
                        catch (Exception e) {
                            BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Method)accessibleObject);
                            continue;
                        }
                    }
                    if (KeyDispatchCodec.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) {
                        try {
                            codec[0] = ((KeyDispatchCodec)((Method)accessibleObject).invoke(obj, new Object[0])).codec();
                            BCLib.LOGGER.debug("      Got Codec from " + (Method)accessibleObject);
                            break;
                        }
                        catch (Exception e) {
                            BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Method)accessibleObject);
                            continue;
                        }
                    }
                    if (!class_7243.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) continue;
                    try {
                        codec[0] = ((class_7243)((Method)accessibleObject).invoke(obj, new Object[0])).comp_640();
                        BCLib.LOGGER.debug("      Got Codec from " + (Method)accessibleObject);
                        break;
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Method)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !"DIRECT_CODEC".equals(((Field)accessibleObject).getName())) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    try {
                        codec[0] = (Codec)((Field)accessibleObject).get(null);
                        BCLib.LOGGER.debug("      Got Codec from " + (Field)accessibleObject);
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("      !!! Unable to get Codec from " + (Field)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !"CODEC".equals(((Field)accessibleObject).getName())) continue;
                    try {
                        ((Field)accessibleObject).setAccessible(true);
                        codec[0] = (Codec)((Field)accessibleObject).get(null);
                        BCLib.LOGGER.debug("      Got Codec from " + (Field)accessibleObject);
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Field)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !Codec.class.isAssignableFrom(((Field)accessibleObject).getType())) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    try {
                        codec[0] = (Codec)((Field)accessibleObject).get(null);
                        BCLib.LOGGER.debug("      Got Codec from " + (Field)accessibleObject);
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Field)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                codec[0] = registry.comp_351().method_39673();
            }
            if (codec[0] == null) {
                codec[0] = registry.comp_351().method_39673();
            }
            if (codec[0] != null) {
                try {
                    JsonObject o = codec[0].encodeStart((DynamicOps)registryOps, obj).result().orElse(new JsonObject());
                    String content = gson.toJson((Object)o);
                    try {
                        Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        BCLib.LOGGER.error("      ->> Unable to WRITE: " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    BCLib.LOGGER.error("      ->> Unable to encode: " + e.getMessage());
                }
            } else {
                BCLib.LOGGER.error("     !!! Could not determine Codec: " + obj.getClass());
            }
        });
    }

    private static <T> void dumpTags(File base, class_5455.class_6892<T> registry, class_6903<JsonElement> registryOps, Gson gson) {
        registry.comp_351().method_40273().map(tagKey -> registry.comp_351().method_40266(tagKey)).filter(tag -> tag.isPresent()).map(tag -> (class_6885.class_6888)tag.get()).forEach(tag -> {
            File f1 = new File(base, tag.method_40251().comp_327().method_12836());
            f1 = new File(f1, "tags");
            f1 = new File(f1, registry.comp_350().method_29177().method_12832());
            f1 = new File(f1, tag.method_40251().comp_327().method_12832() + ".json");
            f1.getParentFile().mkdirs();
            class_7475 tf = new class_7475(tag.method_40239().map(holder -> holder.method_40230()).filter(k -> k.isPresent()).map(k -> class_3497.method_43937((class_2960)((class_5321)k.get()).method_29177())).toList(), true);
            JsonElement o = (JsonElement)class_7475.field_39269.encodeStart((DynamicOps)registryOps, (Object)tf).result().orElse(new JsonObject());
            String content = gson.toJson(o);
            try {
                Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                BCLib.LOGGER.error("      ->> Unable to WRITE: " + e.getMessage());
            }
        });
    }

    private record Dumper<T, C extends Codec<? extends T>, H extends class_6880<? extends T>>(Function<T, C> codecFunction, Function<class_6880<T>, T> contentTransform) {
        Dumper(Function<T, C> codecFunction) {
            this(codecFunction, h -> h.comp_349());
        }
    }
}

